
#IFDEF __STORY_DEBUG__
	Print __Alisha_._Project & " DevKit " & __Alisha_._Version_Pretty & " Core / VGA Lookup"
	SimpleSleep ( )
#ENDIF

ReDim Shared As String VGA_Table ( Any )

Declare Sub VGA_Load ( VGA_Table ( Any ) As String, Filename As String = "" )

Declare Function VGA_Lookup ( Index As Integer = 0 ) As uLongInt

Declare Function VGA_Lookup2 ( Index As Integer = 0, VGA_Table ( Any ) As String ) As uLongInt

Sub VGA_Load ( VGA_Table ( Any ) As String, Filename As String = "" )	
	
	Erase VGA_Table
	ReDim VGA_Table ( -1 To -1 )
	
	Dim As String ReserveBuffer, OutBuffer

	If Is_File ( Filename ) = 0 Then
		Exit Sub
	End If

	Dim As Long FileMode = FreeFile

	If FileMode = 0 Then
		Close #FileMode
		Exit Sub
	End If
	
	IF Open ( Filename For Binary As #FileMode ) Then
		Close #FileMode
		FileMode = 0
		Exit Sub
	End If

	ReserveBuffer = Space ( Lof ( Filemode ) )
	Get #Filemode, 1, ReserveBuffer
	Close #Filemode
	
	Do While Len ( ReserveBuffer ) > 0
		
		OutBuffer = Prefix ( CRLF, ReserveBuffer )
		ReserveBuffer = Suffix ( CRLF, ReserveBuffer )
		ReDim Preserve VGA_Table ( 0 To UBound ( VGA_Table ) + 1 )
		VGA_Table ( UBound ( VGA_Table, 1 ) ) = Trim ( OutBuffer, QUOT )
	
	Loop
	
	Exit Sub
	
End Sub

Function VGA_Lookup ( Index As Integer = 0 ) As uLongInt
	
	With __Alisha_
		Return VGA_Lookup2 ( Index, ._VGA_Table ( ) )
	End With
	
End Function

Function VGA_Lookup2 ( Index As Integer = 0, VGA_Table ( Any ) As String ) As uLongInt

	Select Case Index

	Case 0 To 255

		VGA_Lookup2 = ValULng ( VGA_Table ( Index ) )
		Exit Function
		
	Case Else

		VGA_Lookup2 = Index
		Exit Function

	End Select

End Function
